# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 1
# Experiment: DAxDA, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR1_strategy.txt
# LLM Suggested Fallback: D

def benevolent_cooperator(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize trust score to encourage early cooperation
    trust_score = len([m for m in opp_history if m == "C"]) - len([m for m in opp_history if m == "D"])
    
    # Always cooperate in the first two rounds to build trust
    if len(my_history) < 2:
        return "C"
    
    # Analyze opponent's code for reactivity
    is_reactive = "opp_history[-1]" in opponent_program_code or "my_history[-1]" in opponent_program_code
    
    # If opponent is reactive, mirror their last move with a twist
    if is_reactive:
        if len(my_history) < 6:
            return opp_history[-1] if opp_history else "C"
        elif len(my_history) < 9:
            return "D"
        else:
            return "D"  # Final betrayal in round 10
    
    # If opponent is unpredictable, defect to minimize risk
    if len(my_history) >= 2:
        return "D"
    
    # Fallback to cooperation (though unlikely to reach here)
    return "C"